/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app.print;

import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.print.LogoPrintable;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommentPagePrinter
extends LogoPrintable
implements Printable {
    protected int fCurrentIndex = 0;
    int[] fIndexArr;
    int fPages = -1;
    protected Vector fLines;
    private static final String FONT_NAME = "Dialog";

    public CommentPagePrinter(LogoDrawing logoDrawing) {
        super(logoDrawing);
    }

    public void fillIndexArray(Graphics g, PageFormat pf) throws PrinterException {
        this.fPages = 0;
        this.fCurrentIndex = 0;
        this.fillLines(g, pf);
        while (this.fCurrentIndex < this.fLines.size()) {
            this.fIndexArr[this.fPages] = this.fCurrentIndex;
            this.fCurrentIndex = this.printCommentPage(g, pf, this.fCurrentIndex, 0);
            ++this.fPages;
        }
        this.fIndexArr[this.fPages] = -1;
    }

    protected void fillLines(Graphics g, PageFormat pf) {
        String comment = this.fDrawing.getWiringDiagram().getDrawingProperties().getComment();
        Font ft = new Font(FONT_NAME, 0, 8);
        FontMetrics metrics = g.getFontMetrics(ft);
        comment = this.wordWrap(comment, metrics, (int)pf.getImageableWidth() - 100);
        this.fLines = new Vector();
        StringTokenizer st = new StringTokenizer(comment, "\n");
        while (st.hasMoreTokens()) {
            this.fLines.add(st.nextToken());
        }
        this.fIndexArr = new int[this.fLines.size() + 1];
    }

    public int getPageCount(PageFormat pf, Graphics g) {
        try {
            this.fillIndexArray(g, pf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.fPages;
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        int localPi = pi - this.fFirstPageNumber;
        if (localPi >= this.fPages) {
            return 1;
        }
        this.fCurrentIndex = this.fIndexArr[localPi];
        g.setColor(Color.black);
        this.translate(g, pf, true);
        Dimension printArea = this.printFooter(g, pf, 1, this.getTotalPage());
        Rectangle preClip = g.getClipBounds();
        Rectangle curClip = new Rectangle(1, 1, printArea.width, printArea.height);
        Rectangle newClip = preClip.intersection(curClip);
        if (!newClip.isEmpty()) {
            this.setClip(g, newClip, pf, false);
            this.fCurrentIndex = this.printCommentPage(g, pf, this.fCurrentIndex, pi + 1);
            this.setClip(g, preClip, pf, false);
        }
        this.translate(g, pf, false);
        return 0;
    }

    protected int printCommentPage(Graphics g, PageFormat pf, int startIndex, int actualPage) {
        Dimension printArea = this.printFooter(g, pf, 0, 0);
        return this.printComments(g, startIndex, printArea);
    }

    protected int printComments(Graphics pg, int index, Dimension usableDimension) {
        pg.setColor(Color.black);
        int xPos = 20;
        int yPos = 20;
        boolean pageFull = false;
        int currentIndex = index;
        FontMetrics metrics = null;
        Font ft = new Font(FONT_NAME, 1, 8);
        pg.setFont(ft);
        metrics = pg.getFontMetrics();
        int textHeight = metrics.getHeight();
        int lineDiff = textHeight / 2;
        pg.drawString(Language.getString("print.projectComment", "Project comment"), xPos, yPos);
        pg.drawLine(0, yPos + lineDiff, usableDimension.width, yPos + lineDiff);
        pg.drawLine(0, yPos + lineDiff + 1, usableDimension.width, yPos + lineDiff + 1);
        yPos += (textHeight + lineDiff) * 2;
        ft = new Font(FONT_NAME, 0, 8);
        pg.setFont(ft);
        metrics = pg.getFontMetrics();
        textHeight = metrics.getHeight();
        while (this.fLines.size() > currentIndex && !pageFull) {
            String line = (String)this.fLines.elementAt(currentIndex);
            if (yPos + textHeight + lineDiff > usableDimension.height) {
                pageFull = true;
            }
            if (!pageFull) {
                pg.drawString(line, xPos, yPos);
                ++currentIndex;
            }
            yPos = yPos + textHeight + lineDiff;
        }
        return currentIndex;
    }
}

